Imports System
Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.IO

Public Class HotelExtension : Inherits System.Web.Services.Protocols.SoapExtension
    Private m_oldStream As Stream
    Private m_newStream As Stream

    Private m_encryptionParameter As String

    Private m_filename As String = "C:\sampleFile.txt"

    Public Overrides Sub ProcessMessage(ByVal message As System.Web.Services.Protocols.SoapMessage)
        Select Case message.Stage
            Case SoapMessageStage.BeforeSerialize
                Return

            Case SoapMessageStage.AfterSerialize
                'This section of code is hit after ASP.NET has serialized the request to an XML format,
                'but before the SOAP XML message is sent across the network to the XML Web Service.
                Encrypt(message)

            Case SoapMessageStage.BeforeDeserialize
                'This section of code is hit before ASP.NET has deseralized the SOAP XML message
                'into a return value (along with any out parameters)
                Decrypt(message)

            Case SoapMessageStage.AfterDeserialize
                Return

            Case Else
                Throw New Exception("invalid stage")
        End Select
    End Sub

    Public Overrides Sub Initialize(ByVal initializer As Object)
        m_encryptionParameter = initializer.EncryptParameter
    End Sub

    Public Overloads Overrides Function GetInitializer(ByVal methodInfo As System.Web.Services.Protocols.LogicalMethodInfo, ByVal attribute As System.Web.Services.Protocols.SoapExtensionAttribute) As Object
        Return attribute
    End Function

    Public Overrides Function ChainStream(ByVal stream As Stream) As Stream
        m_oldStream = stream
        m_newStream = New MemoryStream()
        Return m_newStream
    End Function

    Public Overloads Overrides Function GetInitializer(ByVal serviceType As System.Type) As Object
        Return GetType(HotelExtension)
    End Function

    Public Sub Encrypt(ByVal message As SoapMessage)
        m_newStream.Position = 0
        Dim fs As New FileStream(m_filename, FileMode.Append, FileAccess.Write)
        Dim w As New StreamWriter(fs)

        Dim strNodeToEncrypt As String = "/" & m_encryptionParameter
        System.Diagnostics.EventLog.WriteEntry("HotelExtension", "SOAP XML node to encrypt: " & strNodeToEncrypt)

        'TODO: encryption code here

        w.Flush()
        Copy(m_newStream, fs)
        fs.Close()
        m_newStream.Position = 0
        Copy(m_newStream, m_oldStream)
    End Sub

    Public Sub Decrypt(ByVal message As SoapMessage)
        Copy(m_oldStream, m_newStream)
        Dim fs As New FileStream(m_filename, FileMode.Append, FileAccess.Write)
        Dim w As New StreamWriter(fs)

        Dim strNodeToEncrypt As String = "/" & m_encryptionParameter
        System.Diagnostics.EventLog.WriteEntry("HotelExtension", "SOAP XML node to decrypt: " & strNodeToEncrypt)

        'TODO: decryption code here

        w.Flush()
        m_newStream.Position = 0
        Copy(m_newStream, fs)
        fs.Close()
        m_newStream.Position = 0
    End Sub

    Sub Copy(ByVal fromStream As Stream, ByVal toStream As Stream)
        Dim reader As New StreamReader(fromStream)
        Dim writer As New StreamWriter(toStream)
        writer.WriteLine(reader.ReadToEnd())
        writer.Flush()
    End Sub

End Class

